-- GM HC11 CPU Core
-- Copyright (C) Green Mountain Computing Systems, 2000
-- All rights reserved.
--
-- This file may not be freely distributed.  This file has been provided
-- under the terms of the GM Core License Agreement in license.txt.
--
-- testcore.vhd : This is a behavior testbench model that can be used to
--     simulate the execution of a program on the CPU.  The eprom instance
--     simulates a rom containing the program which is read from the rom.s19
--     file at simulation time.
--
-- 8/22/00 : Created - Scott Thibault
--

library ieee;
use ieee.std_logic_1164.all;

entity testbench is
end;

architecture behav of testbench is
  signal extal : std_logic;
  signal ptaclk : std_logic;
  signal E : std_logic;
  signal ph1 : std_logic;
  signal ph2 : std_logic;
  signal reset, cpu_reset : std_logic;
  signal as : std_logic;
  signal bus_rw : std_logic;
  signal bus_addr : std_logic_vector (15 downto 0);
  signal bus_data : std_logic_vector (7 downto 0);
  signal ino : std_logic_vector (3 downto 0);
  signal iavail : std_logic;
  signal cpu_data : std_logic_vector (7 downto 0);
  signal iaccept : std_logic;
begin
  clock_1 : entity clock
    port map (extal, E, ph1, ph2, as, ptaclk);

  eprom : entity srec_rom
    port map (E, ph1, ph2, reset, as, bus_rw, bus_addr, bus_data);

  hc11ram_1 : entity hc11ram
    port map (E, ph1, ph2, reset, as, bus_rw, bus_addr, bus_data);

  dev_1 : entity dev
    port map (E, ph1, ph2, reset, as, bus_rw, bus_addr, BUS_DATA);

  core : entity hc11core
    port map (E, ph1, cpu_reset, ino, iavail, iaccept, open, open, bus_rw, bus_addr, bus_data, cpu_data);

  reset <= '0', '1' after 333 ns;
  cpu_reset <= not reset;

  data_tristate : process (bus_rw, cpu_data)
  begin
    if (bus_rw='1') then
      bus_data <= "ZZZZZZZZ";
    else
      bus_data <= cpu_data;
    end if;
  end process;
end;

