-- GM HC11 CPU Core
-- Copyright (C) Green Mountain Computing Systems, 2000
-- All rights reserved.
--
-- This file may not be freely distributed.  This file has been provided
-- under the terms of the GM Core License Agreement in license.txt.
--
-- syncore.vhd : This file is just an instantiation of the CPU for synthesis.
--     It configures the CPU for non-test mode and strips the debugging outputs
--     from the interface.
--
-- 8/22/00 : Created - Scott Thibault
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity hc11core is
  port (E, ph1 : in std_logic;
        reset : in std_logic;
        ino : in std_logic_vector (3 downto 0);
        iavail : in std_logic;
        iaccept, CCR_X, CCR_I : out std_logic;
        rw : out std_logic;
        address : out std_logic_vector (15 downto 0);
        data : in std_logic_vector (7 downto 0);
        write_data : out std_logic_vector (7 downto 0));
end;

architecture structure of hc11core is
    signal micro : unsigned ( 3 downto 0 ); 
    signal SP : STD_LOGIC_VECTOR ( 15 downto 0 ); 
    signal X :  STD_LOGIC_VECTOR ( 15 downto 0 ); 
    signal CCR : STD_LOGIC_VECTOR ( 7 downto 0 ); 
    signal A : STD_LOGIC_VECTOR ( 7 downto 0 ); 
    signal Y : STD_LOGIC_VECTOR ( 15 downto 0 ); 
    signal B : STD_LOGIC_VECTOR ( 7 downto 0 ); 
begin
  cpu : entity hc11cpu
    generic map (false)
    port map (E=> E, PH1 => ph1, RESET => reset, INO => ino, IAVAIL => iavail, IACCEPT => iaccept,
              CCR_X => CCR_X, CCR_I => CCR_I, RW => rw, ADDRESS => address, DATA => data,
              WRITE_DATA => write_data, DEBUG_MICRO => micro, DEBUG_SP => SP, DEBUG_X => X,
              DEBUG_CCR => CCR, DEBUG_A => A, DEBUG_Y => Y, DEBUG_B => B);
end;

