	opt	l
	org	$20
output	fcb	5

	org	$f800

start
	ldx	#0		* nice safe starting value
	lds	#$ff		* stack at top of ram

	ldaa	#$08		* enable sci transmiter
	staa	$102d

	ldx	#output		* where the answer goes
	ldd	#1234		* what goes there
	jsr	hex_word	* make it happen
	jsr	outstr		* output it to the sci device
loop:	jmp	loop		* and then wait in a safe place

* output a string to the SCI device
outstr:
	psha
	pshb
	pshx
out1	ldaa	0,x
	inx
out2	ldab	$102e
	bitb	#$80
	beq	out2
	anda	#$7f
	staa	$102f
	cmpa	#$0d
	bne	out1
	pulx
	pulb
	pula
	rts

* convert the low 4 bits of A to a single character which is
* returned in the address pointed to by X.  X is incremented.
hex_nybble:
	psha			* cleanliness as a policy
	anda	#$0f		* only the low nybble
	suba	#10		* check for 0-9 versus a-f
	blt	hex_low
	adda	#'a-'0-10	* note that 10-10+('a-'0-10)+('0+10) = 'a
hex_low:
	adda	#'0+10		* fixes digits, finishes fixing a-f
	sta	0,x		* store result
	inx			* point to next character
	pula			* cleanliness again
	rts

* convert the 8 bit number in A into the 2 character ASCII number.
* the result is stored in memory pointed to by X which is incremented
* to point past the result.
hex_byte:
	psha			* save low nybble for later
	lsra			* get high nybble to print first
	lsra
	lsra
	lsra
	jsr	hex_nybble	* and pump it out
	pula			* get low nybble back
	jmp	hex_nybble	* same as jsr,rts

* convert the 16 bit number in D into the 4 character ASCII
* representation of its value in base 16

* args are D, the number to convert and
*          X, which contains the address for the result

* on exit, all regs are unchanged and the 5 bytes pointed to by X
* contain a null terminated string which, when printed, is the
* hexadecimal value of D
hex_word:
	pshx			* save x for later
	jsr	hex_byte	* put high byte from a
	psha			* save a for return
	tba			* now do low byte (from b)
	jsr	hex_byte
	lda	#$0D		* store terminator
	sta	0,x
	pula			* and restore a
	pulx			* and x
	rts			* so we return without changing regs

	org	$fffe		* reset vector
	fdb	start
