source disasm.tcl

proc format_vec {form vec} {
    set ival [vec_uint $vec]
    if {$ival == "NAN"} {
        return "NAN"
    }
    format $form $ival
}

proc refresh_ram {} {
    global ram_addr

    if {$ram_addr != ""} {
      for {set i 0} {$i < 32} {incr i 1} {
        set byteval [vec_uint [ram subvalue [expr $ram_addr + $i]]]
        if {$byteval == "NAN"} {
            lappend val "UU"
        } else {
            lappend val [format "%02x" $byteval]
        }
      }
      .rammsg configure -text $val
    }
    expr 1
}

proc show_ram {} {
    global show_ram ram_addr

    destroy .rambtn
    message .rammsg -width 330 -font *-courier-medium-r-normal--*-128-*-*-*-*-*-*
    entry .ramentry -width 4 -textvariable ram_addr
    bind .ramentry <Any-KeyRelease> {refresh_ram}
    button .rambtn -text "Hide" -command hide_ram
    pack .ramentry .rammsg .rambtn -in .ramfrm -side left

    set show_ram 1

    refresh_ram
}

proc hide_ram {} {
   destroy .rambtn
   destroy .rammsg
   destroy .ramentry
   button .rambtn -text "RAM" -command show_ram
   pack .rambtn -in .ramfrm -side left

   set show_ram 0
}

proc refresh_display {} {
    global insn_addr show_ram

    .pcval configure -text [format_vec "%04x" [PC value]]
    .spval configure -text [format_vec "%04x" [SP value]]
    .aval configure -text [format_vec "%02x" [A value]]
    .bval configure -text [format_vec "%02x" [B value]]
    .xval configure -text [format_vec "%04x" [X value]]
    .yval configure -text [format_vec "%04x" [Y value]]    

    set ccrval [vec_str [CCR value]]
    if {$ccrval != "NAN"} {
        .ccrsval configure -text [string index $ccrval 0]
        .ccrxval configure -text [string index $ccrval 1]
        .ccrhval configure -text [string index $ccrval 2]
        .ccrival configure -text [string index $ccrval 3]
        .ccrnval configure -text [string index $ccrval 4]
        .ccrzval configure -text [string index $ccrval 5]
        .ccrvval configure -text [string index $ccrval 6]
        .ccrcval configure -text [string index $ccrval 7]
    }

    set ival [vec_uint $insn_addr]
    if {$ival != "NAN"} {
        .addrlbl configure -text [format_vec "%04x" $insn_addr]
        .insnlbl configure -text [lindex [dis_inst [vec_uint $insn_addr]] 1]
    }

    if {$show_ram} {
        refresh_ram
    }
}

proc new_state {} {
    global insn_addr do_stepi stop_pc

    if {[state value] == "FETCH1"} {
        set insn_addr [address value]
    }
    if {[state value] == "FETCH2"} {
        if {$do_stepi == "true"} {
            stop_sim
        }
        if {$insn_addr == $stop_pc} {
            stop_sim
        }
    }
    expr 1
}

proc stepi {} {
    global do_stepi

    set do_stepi true
    simfor 10us
    set do_stepi false
    get_time
}

proc execto {addr} {
    global stop_pc

    set stop_pc [uint_vec [expr $addr] 16]
    simfor 1ms
    set stop_pc {}
}

proc disassemble {start end} {
    destroy .disassembly
    toplevel .disassembly
    text .disassembly.listing -yscrollcommand ".disassembly.scroll set"
    scrollbar .disassembly.scroll -command ".disassembly.listing yview"
    pack .disassembly.scroll -side right -fill y
    pack .disassembly.listing -side left

    set i $start
    while {$i < $end} {
        set result [dis_inst $i]
        .disassembly.listing insert end [concat [format "%02x" $i] [lindex $result 1]]
        .disassembly.listing insert end "\n"
        set i [lindex $result 0]
    }
    .disassembly.listing insert end "end\n"
}

signal rom -this [lookup_signal eprom.do_rom.mem]
signal ram -this [lookup_signal hc11ram_1.ram.mem]
signal state -this [lookup_signal core.cpu.state]
signal opcode -this [lookup_signal core.cpu.opcode]
signal address -this [lookup_signal core.cpu.address_i]
signal y_prefix -this [lookup_signal core.cpu.y_prefix]
signal d_prefix -this [lookup_signal core.cpu.d_prefix]
signal A -this [lookup_signal core.cpu.A]
signal B -this [lookup_signal core.cpu.B]
signal X -this [lookup_signal core.cpu.X]
signal Y -this [lookup_signal core.cpu.Y]
signal CCR -this [lookup_signal core.cpu.CCR]
signal PC -this [lookup_signal core.cpu.PC]
signal SP -this [lookup_signal core.cpu.SP]

frame .sregsfrm
frame .sregsfrm.pcfrm
label .pclbl -text "PC:"
label .pcval -text "----"
frame .sregsfrm.spfrm
label .splbl -text "SP:"
label .spval -text "----"

frame .regsfrm
frame .regsfrm.afrm
label .albl -text "A:"
label .aval -text "--"
frame .regsfrm.bfrm
label .blbl -text "B:"
label .bval -text "--"
frame .regsfrm.xfrm
label .xlbl -text "X:"
label .xval -text "----"
frame .regsfrm.yfrm
label .ylbl -text "Y:"
label .yval -text "----"

frame .flagsfrm
label .ccrslbl -text "S:"
label .ccrsval -text "-"
label .ccrxlbl -text " X:"
label .ccrxval -text "-"
label .ccrhlbl -text " H:"
label .ccrhval -text "-"
label .ccrilbl -text " I:"
label .ccrival -text "-"
label .ccrnlbl -text " N:"
label .ccrnval -text "-"
label .ccrzlbl -text " Z:"
label .ccrzval -text "-"
label .ccrvlbl -text " V:"
label .ccrvval -text "-"
label .ccrclbl -text " C:"
label .ccrcval -text "-"

pack .sregsfrm -side top -anchor w
pack .sregsfrm.pcfrm .sregsfrm.spfrm -side left
pack .pclbl .pcval -side left -in .sregsfrm.pcfrm
pack .splbl .spval -side left -in .sregsfrm.spfrm

pack .regsfrm -side top -anchor w
pack .regsfrm.afrm .regsfrm.bfrm .regsfrm.xfrm .regsfrm.yfrm -side left
pack .albl .aval -side left -in .regsfrm.afrm
pack .blbl .bval -side left -in .regsfrm.bfrm
pack .xlbl .xval -side left -in .regsfrm.xfrm
pack .ylbl .yval -side left -in .regsfrm.yfrm

pack .flagsfrm -side top -anchor w
pack .ccrslbl .ccrsval .ccrxlbl .ccrxval .ccrhlbl .ccrhval .ccrilbl .ccrival .ccrnlbl .ccrnval .ccrzlbl .ccrzval .ccrvlbl .ccrvval .ccrclbl .ccrcval -side left -in .flagsfrm

frame .disasmfrm
label .addrlbl -text "----"
label .insnlbl

pack .disasmfrm -side top -anchor w
pack .addrlbl .insnlbl -in .disasmfrm -side left

frame .ramfrm
button .rambtn -text "RAM" -command show_ram

pack .rambtn -in .ramfrm -side left
pack .ramfrm -side top -anchor w

button .stepibtn -text "Step" -command stepi
pack .stepibtn -anchor w

set insn_addr [address value]
set do_stepi false
set stop_pc {}
set show_ram 0
set ram_addr 0

refresh_display

insert_refresh_handler refresh_display
state event_callback new_state

