proc decode_type1 {addrvar opcode y_prefix} {
    upvar $addrvar romaddr
    set mode [expr $opcode & 0x30]
    switch [format "%02x" $mode] {
        00 {
            set ret #[vec_uint [rom subvalue $romaddr]]
            set romaddr [expr $romaddr + 1]
        }
        10 {
            set ret $[format "%02x" [vec_uint [rom subvalue $romaddr]]]
            set romaddr [expr $romaddr + 1]
        }
        30 {
            set hi [vec_uint [rom subvalue $romaddr]]
            set lo [vec_uint [rom subvalue [expr $romaddr + 1]]]
            set ret $[format "%02x" [expr $hi * 256 + $lo]]
            set romaddr [expr $romaddr + 2]
        }
        20 {
            if {$y_prefix} {
                set ret [vec_uint [rom subvalue $romaddr]],y
            } else {
                set ret [vec_uint [rom subvalue $romaddr]],x
            }
            set romaddr [expr $romaddr + 1]
        }
    }
    return $ret
}

proc decode_type1d {addrname opcode y_prefix} {
    upvar $addrname romaddr
    set mode [expr $opcode & 0x30]
    switch [format "%02x" $mode] {
        00 {
            set hi [expr [vec_uint [rom subvalue $romaddr]] * 256]
            set ret #[expr $hi + [vec_uint [rom subvalue [expr $romaddr + 1]]]]
            set romaddr [expr $romaddr + 2]
        }
        10 {
            set ret $[format "%02x" [vec_uint [rom subvalue $romaddr]]]
            set romaddr [expr $romaddr + 1]
        }
        30 {
            set hi [vec_uint [rom subvalue $romaddr]]
            set lo [vec_uint [rom subvalue [expr $romaddr + 1]]]
            set ret $[format "%02x" [expr $hi * 256 + $lo]]
            set romaddr [expr $romaddr + 2]
        }
        20 {
            if {$y_prefix} {
                set ret [vec_uint [rom subvalue $romaddr],y]
            } else {
                set ret [vec_uint [rom subvalue $romaddr],x]
            }
            set romaddr [expr $romaddr + 1]
        }
    }
    return $ret
}

proc decode_branch {addrname} {
    upvar $addrname romaddr
    set base [expr $romaddr + 53249]
    set rr [vec_int [rom subvalue $romaddr]]
    set romaddr [expr $romaddr + 1]
    return $[format "%04x" [expr $base + $rr]]
}

proc dis_inst {addr} {

    set romaddr [expr $addr - 53248]

    set opcode [vec_uint [rom subvalue $romaddr]]
    switch [format %02x" $opcode] {
        18 {
            set y_prefix 1
            set d_prefix 0
            set romaddr [expr $romaddr + 1]
            set opcode [vec_uint [rom subvalue $romaddr]]
        }
        1a {
            set y_prefix 0
            set d_prefix 1
            set romaddr [expr $romaddr + 1]
            set opcode [vec_uint [rom subvalue $romaddr]]
        }
        cd {
            set y_prefix 1
            set d_prefix 1
            set romaddr [expr $romaddr + 1]
            set opcode [vec_uint [rom subvalue $romaddr]]
        }
        default {
            set y_prefix 0
            set d_prefix 0
        }
    }

    set romaddr [expr $romaddr + 1]
    set args ""

    switch [format "%02x" $opcode] {
        1b {
            set opname aba
        }
        3a {
            if {$y_prefix} {
                set opname aby
            } else {
                set opname abx
            }
        }
        48 {
            set opname asla
        }
        58 {
            set opname aslb
        }
        05 {
            set opname asld
        }
        47 {
            set opname asra
        }
        57 {
            set opname asrb
        }
        24 {
            set opname bcc
            set args [decode_branch romaddr]
        }
        15 {
            set opname bclr
            set mm [format "%02x" [vec_uint [rom subvalue [expr $romaddr + 1]]]]
            set args [list #[vec_uint [rom subvalue $romaddr]] $mm]
            set romaddr [expr $romaddr + 2]
        }
        1d {
            set opname bclr
            set mm [format "%02x" [vec_uint [rom subvalue [expr $romaddr + 1]]]]
            if {$y_prefix} {
                set args [list [vec_uint [rom subvalue $romaddr]],y $mm]
            } else {
                set args [list [vec_uint [rom subvalue $romaddr]],x $mm]
            }
            set romaddr [expr $romaddr + 2]
        }
        14 {
            set opname bset
            set mm [format "%02x" [vec_uint [rom subvalue [expr $romaddr + 1]]]]
            set args [list #[vec_uint [rom subvalue $romaddr]] $mm]
            set romaddr [expr $romaddr + 2]
        }
        1c {
            set opname bset
            set mm [format "%02x" [vec_uint [rom subvalue [expr $romaddr + 1]]]]
            if {$y_prefix} {
                set args [list [vec_uint [rom subvalue $romaddr]],y $mm]
            } else {
                set args [list [vec_uint [rom subvalue $romaddr]],x $mm]
            }
            set romaddr [expr $romaddr + 2]
        }
        13 {
            set opname brclr
            set mm [format "%02x" [vec_uint [rom subvalue [expr $romaddr + 1]]]]
            set romaddr [expr $romaddr + 2]
            set loc [decode_branch romaddr]
            set args [list #[vec_uint [rom subvalue $romaddr]] $mm $loc]
        }
        1f {
            set opname brclr
            set mm [format "%02x" [vec_uint [rom subvalue [expr $romaddr + 1]]]]
            set romaddr [expr $romaddr + 2]
            set loc [decode_branch romaddr]
            if {$y_prefix} {
                set args [list [vec_uint [rom subvalue $romaddr]],y $mm $loc]
            } else {
                set args [list [vec_uint [rom subvalue $romaddr]],x $mm $loc]
            }
        }
        12 {
            set opname brset
            set mm [format "%02x" [vec_uint [rom subvalue [expr $romaddr + 1]]]]
            set romaddr [expr $romaddr + 2]
            set loc [decode_branch romaddr]
            set args [list #[vec_uint [rom subvalue $romaddr]] $mm $loc]
        }
        1e {
            set opname brset
            set mm [format "%02x" [vec_uint [rom subvalue [expr $romaddr + 1]]]]
            set romaddr [expr $romaddr + 2]
            set loc [decode_branch romaddr]
            if {$y_prefix} {
                set args [list [vec_uint [rom subvalue $romaddr]],y $mm $loc]
            } else {
                set args [list [vec_uint [rom subvalue $romaddr]],x $mm $loc]
            }
        }
        27 {
            set opname beq
            set args [decode_branch romaddr]
        }
        2c {
            set opname bge
            set args [decode_branch romaddr]
        }
        2e {
            set opname bgt
            set args [decode_branch romaddr]
        }
        22 {
            set opname bhi
            set args [decode_branch romaddr]
        }
        2f {
            set opname ble
            set args [decode_branch romaddr]
        }
        23 {
            set opname bls
            set args [decode_branch romaddr]
        }
        2d {
            set opname blt
            set args [decode_branch romaddr]
        }
        2b {
            set opname bmi
            set args [decode_branch romaddr]
        }
        26 {
            set opname bne
            set args [decode_branch romaddr]
        }
        2a {
            set opname bpl
            set args [decode_branch romaddr]
        }
        20 {
            set opname bra
            set args [decode_branch romaddr]
        }
        21 {
            set opname brn
            set args [decode_branch romaddr]
        }
        28 {
            set opname bvc
            set args [decode_branch romaddr]
        }
        29 {
            set opname bvs
            set args [decode_branch romaddr]
        }
        8d {
            set opname bsr
            set args [decode_branch romaddr]
        }
        11 {
            set opname cba
        }
        0c {
            set opname clc
        }
        0e {
            set opname cli
        }
        0a {
            set opname clv
        }
        4f {
            set opname clra
        }
        5f {
            set opname clrb
        }
        43 {
            set opname coma
        }
        53 {
            set opname comb
        }
        18 {
            set opname daa
        }
        4a {
            set opname deca
        }
        5a {
            set opname decb
        }
        34 {
            set opname des
        }
        09 {
            if {$y_prefix} {
                set opname dey
            } else {
                set opname dex
            }
        }
        03 {
            set opname fdiv
        }
        02 {
            set opname idiv
        }
        4c {
            set opname inca
        }
        5c {
            set opname incb
        }
        31 {
            set opname ins
        }
        08 {
            if {$y_prefix} {
                set opname iny
            } else {
                set opname inx
            }
        }
        44 {
            set opname lsra
        }
        54 {
            set opname lsrb
        }
        48 {
            set opname lsla
        }
        58 {
            set opname lslb
        }
        04 {
            set opname lsrd
        }
        05 {
            set opname lsld
        }
        3d {
            set opname mul
        }
        40 {
            set opname nega
        }
        50 {
            set opname negb
        }
        01 {
            set opname negb
        }
        36 {
            set opname psha
        }
        37 {
            set opname pshb
        }
        3c {
            if {$y_prefix} {
                set opname pshy
            } else {
                set opname pshx
            }
        }
        32 {
            set opname pula
        }
        33 {
            set opname pulb
        }
        38 {
            if {$y_prefix} {
                set opname puly
            } else {
                set opname pulx
            }
        }
        46 {
            set opname rora
        }
        56 {
            set opname rorb
        }
        49 {
            set opname rola
        }
        59 {
            set opname rolb
        }
        3b {
            set opname rti
        }
        39 {
            set opname rts
        }
        0d {
            set opname sec
        }
        0f {
            set opname sei
        }
        0b {
            set opname sba
        }
        cf {
            set opname stop
        }
        3f {
            set opname swi
        }
        16 {
            set opname tab
        }
        06 {
            set opname tap
        }
        17 {
            set opname tba
        }
        00 {
            set opname test
        }
        07 {
            set opname tpa
        }
        4d {
            set opname tsta
        }
        5d {
            set opname tstb
        }
        30 {
            if {$y_prefix} {
                set opname tsy
            } else {
                set opname tsx
            }
        }
        35 {
            if {$y_prefix} {
                set opname tys
            } else {
                set opname txs
            }
        }
        3e {
            set opname wai
        }
        8f {
            if {$y_prefix} {
                set opname xgdy
            } else {
                set opname xgdx
            }
        }
        default {
            set opclass [expr $opcode & 0xcf]
            switch [format "%02x" $opclass] {
                89 {
                    set opname adca
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                c9 {
                    set opname adcb
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                8b {
                    set opname adda
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                cb {
                    set opname addb
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                c3 {
                    set opname addd
                    set args [decode_type1d romaddr $opcode $y_prefix]
                }
                84 {
                    set opname anda
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                c4 {
                    set opname andb
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                48 {
                    set opname asl
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                47 {
                    set opname asr
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                85 {
                    set opname bita
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                c5 {
                    set opname bitb
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                4f {
                    set opname clr
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                81 {
                    set opname cmpa
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                c1 {
                    set opname cmpb
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                43 {
                    set opname com
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                83 {
                    if {$d_prefix} {
                       set opname cpd
                    } else {
                       set opname subd
                    }
                    set args [decode_type1d romaddr $opcode $y_prefix]
                }
                8c {
                    if {$y_prefix} {
                       set opname cpx
                    } else {
                       set opname cpy
                    }
                    set args [decode_type1d romaddr $opcode $y_prefix]
                }
                4a {
                    set opname dec
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                88 {
                    set opname eora
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                c8 {
                    set opname eorb
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                4c {
                    set opname inc
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                4e {
                    set opname jmp
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                8d {
                    set opname jsr
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                86 {
                    set opname ldaa
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                c6 {
                    set opname ldab
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                cc {
                    set opname ldd
                    set args [decode_type1d romaddr $opcode $y_prefix]
                }
                8e {
                    set opname lds
                    set args [decode_type1d romaddr $opcode $y_prefix]
                }
                ce {
                    if {$y_prefix} {
                       set opname ldy
                    } else {
                       set opname ldx
                    }
                    set args [decode_type1d romaddr $opcode $y_prefix]
                }
                44 {
                    set opname lsr
                    set args [decode_type1d romaddr $opcode $y_prefix]
                }
                48 {
                    set opname lsl
                    set args [decode_type1d romaddr $opcode $y_prefix]
                }
                40 {
                    set opname neg
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                8a {
                    set opname oraa
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                ca {
                    set opname orab
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                46 {
                    set opname ror
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                49 {
                    set opname rol
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                82 {
                    set opname sbca
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                c2 {
                    set opname sbcb
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                87 {
                    set opname staa
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                c7 {
                    set opname stab
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                cd {
                    set opname std
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                8f {
                    set opname sts
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                cf {
                    if {$y_prefix} {
                       set opname sty
                    } else {
                       set opname stx
                    }
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                80 {
                    set opname suba
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                c0 {
                    set opname subb
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                4d {
                    set opname tst
                    set args [decode_type1 romaddr $opcode $y_prefix]
                }
                default {
                    set opname [format "%02x" $opcode]
                }
            }
        }
    }

    return [list [expr $romaddr + 53248] [concat $opname $args]]
}

