-- GM HC11 CPU Core
-- Copyright (C) Green Mountain Computing Systems, 2000
-- All rights reserved.
--
-- This file may not be freely distributed.  This file has been provided
-- under the terms of the GM Core License Agreement in license.txt.
--
-- dev.vhd : This is the VHDL behavioral implementation of the HC11's
--        special devices.  Currently, this model only supports SCI output.
--
-- 8/22/00 : Created - Scott Thibault
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity dev is
  port (E : in std_logic;
        ph1, ph2, reset : in std_logic;

        -- System bus signals
        as, bus_rw : in std_logic;
        bus_addr : in std_logic_vector(15 downto 0);
        bus_data : inout std_logic_vector(7 downto 0));
end dev;

use textio.all;

architecture behavior of dev is
begin
  main : process
    variable address : integer;  -- Latched bus address value
    variable rw : std_logic;
    variable scibuf : line;
  begin
    bus_data <= "ZZZZZZZZ";
    -- loop for every taking read and write requests
    loop
      -- wait until address strobe and address in register block range
      wait until as='0';
      while reset='0' loop
        wait until as='0';
      end loop;

      -- Latch address and rw at address strobe
      address:=to_integer(unsigned(bus_addr));
      rw:=bus_rw;

      wait until ph1='1';  -- wait for start data valid

      if (rw = '1') then
        case address is
        when 16#102e# =>
          bus_data <= "11000000";
          wait until ph1='0';
          bus_data <= "ZZZZZZZZ";  -- remove driver at end of data valid
        when others =>
          null;
        end case;
      else -- write
        case address is
        when 16#102f# =>
          if (bus_data = X"0d") then
            writeline(output,scibuf);
          else
            write(scibuf,character'val(to_integer(unsigned(bus_data))));
          end if;
          wait until ph1='0';
        when others =>
          null;
        end case;
      end if;
    end loop;
  end process;
end behavior;
