--
-- GM HC11 CPU Core
-- Copyright (C) Green Mountain Computing Systems, 2000
-- All rights reserved.
--
-- This file may not be freely distributed.  This file has been provided
-- under the terms of the GM Core License Agreement in license.txt.
--
-- clkgen.vhd : This is the VHDL behavioral implementation of the HC11's
--        internal and external clocks.
--
-- 8/14/00 : Created - Scott Thibault
--

-- The clock entity generates all internal and external clocks using the
-- cycle time of an external clock.  The Tcycle generic defines the cycle
-- type of the external clock.  The ph1,ph2, and ptaclk are internal clocks
-- used throughout the reference manual.

library ieee;
use ieee.std_logic_1164.all;

entity clock is
  generic (Tcycle : time := 83.25ns);
  port (extal,E: out std_logic;
        ph1,ph2,as: out std_logic;
        ptaclk: out std_logic);
end clock;

architecture behavoir of clock is
  constant Thalf : time :=Tcycle/2;
begin
  gen_extal: process
  begin
    extal<='0','1' after Thalf;
    wait for Tcycle;
  end process;

  gen_clock: process
  begin
    -- main HC11 clock is extal/4
    E<='0','1' after Tcycle*2;
    -- ph2 is E shifted 90 degrees
    ph2<='0','1' after Tcycle,'0' after Tcycle*3;
    -- ph1 is ph2 inverted
    ph1<='1','0' after Tcycle,'1' after Tcycle*3;
    -- address strobe
    as<='0','1' after Thalf,'0' after Thalf*3;
    -- clock reference for port A pin logic
    ptaclk<='1','0' after Tcycle;
    wait for Tcycle*4;
  end process;
end behavoir;
